package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.admin.dto.TermsConditionsVerHistDTO;
import gov.va.med.mhv.admin.model.TermsConditionsVerHist;

import org.springframework.stereotype.Component;

@Component
public class TermsConditionsVerHistConverter {

	public TermsConditionsVerHistDTO convertFrom(TermsConditionsVerHist t) {
		TermsConditionsVerHistDTO dto = new TermsConditionsVerHistDTO();
		dto.setId(t.getId());
		dto.setOplock(t.getOplock());
		dto.setUpdatedTime(t.getUpdatedTime());
		dto.setVersionInfo(t.getVersionInfo());
		return dto;
	}

	public TermsConditionsVerHist convertTo(TermsConditionsVerHistDTO dto) {
		TermsConditionsVerHist t = new TermsConditionsVerHist();
		t.setId(dto.getId());
		t.setOplock(dto.getOplock());
		t.setUpdatedTime(dto.getUpdatedTime());
		t.setVersionInfo(dto.getVersionInfo());
		return t;
	}

	public List<TermsConditionsVerHistDTO> convertList(List<TermsConditionsVerHist> termsConditionsVerHistList) {
		List<TermsConditionsVerHistDTO> list = new ArrayList<TermsConditionsVerHistDTO>();

		if (termsConditionsVerHistList != null) {
			for (TermsConditionsVerHist listItem : termsConditionsVerHistList) {
				TermsConditionsVerHistDTO dto = convertFrom(listItem);
				list.add(dto);
			}
		}

		return list;
	}

}
